/*
 * Zappoco        - MH_Z19B   16/11/2018 
 * 
 */
#include <SoftwareSerial.h>
#define pwmPin 10
SoftwareSerial mySerial(A0, A1); // RX, TX

byte cmd[9] = {0xFF,0x01,0x86,0x00,0x00,0x00,0x00,0x00,0x79};
unsigned char response[9]; 
unsigned long th, tl,ppm, ppm3, temperatura, sts= 0;

void setup() {
  Serial.begin(9600); 
  mySerial.begin(9600); 
  pinMode(pwmPin, INPUT);
}

void loop() {
  
  mySerial.write(cmd,9);
  mySerial.readBytes(response, 9);
  unsigned int responseHigh = (unsigned int) response[2];
  unsigned int responseLow = (unsigned int) response[3];
  ppm = (256*responseHigh)+responseLow;
  temperatura = response[4] - 40; // alcuni fanno -44 - non documentato sul datasheet
  sts = response[5]; // status
  unsigned int uHigh = (unsigned int) response[6]; //forse umidità H - non documentato sul datasheet
  unsigned int uLow  = (unsigned int) response[7];  //forse umidità L - non documentato sul datasheet
  unsigned int chck  = (unsigned int) response[7];   //checksum

  Serial.print   ("Time         : ");Serial.println (millis());
  Serial.println ("numero       : 00 01 02 03 04 05 06 07 08");
  Serial.println ("signific     : FF CM HH LL TT SS Uh Ul CS");
  Serial.print   ("response     :");
  for (int ico=0; ico<9 ;ico++ )
    {
      int valore = response[ico];
      //Serial.print ("%x", (unsigned char) response[ico]);
      Serial.print (" ");
      if(response[ico] < 16)
        Serial.print ("0");
      Serial.print (response[ico],HEX);
    }
    Serial.println("");

  
  //CO2 via pwm
  do {
    th = pulseIn(pwmPin, HIGH, 1004000) / 1000;
    tl = 1004 - th;
    //ppm2 = 2000 * (th-2)/(th+tl-4);
    ppm3 = 5000 * (th-2)/(th+tl-4);
  } while (th == 0);


  //Serial.print(0.0);
  Serial.println("");
  //Serial.print(",");
  Serial.print("ppm serial   : ");Serial.print(ppm);
  Serial.println("");
  Serial.print("th           : ");Serial.println(th);
  Serial.print("tl           : ");Serial.println(tl);
  //Serial.println(th+tl-4);  //=1000
  //Serial.println(ppm2);
  //Serial.print(",");
  Serial.print("ppm pwm      : "); Serial.println(ppm3);
  Serial.print("ppm pwm red  : "); Serial.println(ppm3*1378/1795); //coefficiente correttivo rispetto al datalogger TROTEC DL200L che monta un sensore ee893
  Serial.print("temperatura  : "); Serial.println(temperatura);
  
  Serial.print("Status       : "); Serial.println(sts);

  Serial.println("-----------");
  delay(5000);
}
